<?php
/**
 * Displays the content on the plugin settings page
 */

if ( ! class_exists( 'Gglcptch_Settings_Tabs' ) ) {
	class Gglcptch_Settings_Tabs extends Bws_Settings_Tabs {
		private $keys, $versions, $forms, $sections;

		/**
		 * Constructor.
		 *
		 * @access public
		 *
		 * @see Bws_Settings_Tabs::__construct() for more information on default arguments.
		 *
		 * @param string $plugin_basename
		 */
		public function __construct( $plugin_basename ) {
			global $gglcptch_options, $gglcptch_plugin_info;

			if ( is_network_admin() ) {
				$tabs = array(
					'settings' => array( 'label' => __( 'Settings', 'google-captcha-pro' ) ),
					'misc'     => array( 'label' => __( 'Misc', 'google-captcha-pro' ) ),
					'license'  => array( 'label' => __( 'License Key', 'google-captcha-pro' ) ),
				);
			} else {
				$tabs = array(
					'settings'    => array( 'label' => __( 'Settings', 'google-captcha-pro' ) ),
					'misc'        => array( 'label' => __( 'Misc', 'google-captcha-pro' ) ),
					'custom_code' => array( 'label' => __( 'Custom Code', 'google-captcha-pro' ) ),
					'license'     => array( 'label' => __( 'License Key', 'google-captcha-pro' ) ),
				);
			}

			parent::__construct(
				array(
					'plugin_basename'    => $plugin_basename,
					'plugins_info'       => $gglcptch_plugin_info,
					'prefix'             => 'gglcptch',
					'default_options'    => gglcptch_get_default_pro_options(),
					'options'            => $gglcptch_options,
					'is_network_options' => is_network_admin(),
					'tabs'               => $tabs,
					'wp_slug'            => 'google-captcha',
					'doc_link'           => 'https://bestwebsoft.com/documentation/recaptcha/recaptcha-user-guide/',
					'doc_video_link'     => 'https://www.youtube.com/watch?v=ZFv6txtic0Y/',
				)
			);

			$this->all_plugins = get_plugins();

			/* Private and public keys */
			$this->keys = array(
				'public'  => array(
					'display_name' => __( 'Site Key', 'google-captcha-pro' ),
					'form_name'    => 'gglcptch_public_key',
					'error_msg'    => '',
				),
				'private' => array(
					'display_name' => __( 'Secret Key', 'google-captcha-pro' ),
					'form_name'    => 'gglcptch_private_key',
					'error_msg'    => '',
				),
			);

			$this->versions = array(
				'v2'        => sprintf( '%s 2', __( 'Version', 'google-captcha-pro' ) ),
				'v3'        => sprintf( '%s 3', __( 'Version', 'google-captcha-pro' ) ),
				'invisible' => __( 'Invisible', 'google-captcha-pro' ),
			);

			/* Supported forms */
			$this->forms = gglcptch_get_forms();

			$this->sections = gglcptch_get_sections();

			if ( $this->is_multisite && ! $this->is_network_options ) {
				if ( $network_options = get_site_option( 'gglcptch_options' ) ) {
					if ( 'all' == $network_options['network_apply'] && 0 == $network_options['network_change'] ) {
						$this->change_permission_attr = ' readonly="readonly" disabled="disabled"';
					}
					if ( 'all' == $network_options['network_apply'] && 0 == $network_options['network_view'] ) {
						$this->forbid_view = true;
					}
				}
			}

			add_action( get_parent_class( $this ) . '_display_custom_messages', array( $this, 'display_custom_messages' ) );
			add_action( get_parent_class( $this ) . '_display_metabox', array( $this, 'display_metabox' ) );
			add_action( get_parent_class( $this ) . '_information_postbox_bottom', array( $this, 'information_postbox_bottom' ) );
		}

		/**
		 * Save plugin options to the database
		 *
		 * @access public
		 * @param  void
		 * @return array    The action results
		 */
		public function save_options() {
			global $wpdb, $gglcptch_languages;

			$message = $notice = $error = '';

			if ( ! $this->forbid_view && empty( $this->change_permission_attr ) ) {
				/* Save data for settings page */
				if ( empty( $_POST['gglcptch_public_key'] ) ) {
					$this->keys['public']['error_msg'] = __( 'Enter site key', 'google-captcha-pro' );
					$error                             = __( 'WARNING: The captcha will not be displayed until you fill key fields.', 'google-captcha-pro' );
				} else {
					$this->keys['public']['error_msg'] = '';
				}

				if ( empty( $_POST['gglcptch_private_key'] ) ) {
					$this->keys['private']['error_msg'] = __( 'Enter secret key', 'google-captcha-pro' );
					$error                              = __( 'WARNING: The captcha will not be displayed until you fill key fields.', 'google-captcha-pro' );
				} else {
					$this->keys['private']['error_msg'] = '';
				}

				if ( $_POST['gglcptch_public_key'] != $this->options['public_key'] || $_POST['gglcptch_private_key'] != $this->options['private_key'] ) {
					$this->options['keys_verified'] = false;
				}

				if ( $_POST['gglcptch_recaptcha_version'] != $this->options['recaptcha_version'] ) {
					$this->options['keys_verified']            = false;
					$this->options['need_keys_verified_check'] = true;
				}

				$this->options['allowlist_message'] = stripslashes( sanitize_text_field( $_POST['gglcptch_allowlist_message'] ) );
				$this->options['public_key']        = stripslashes( sanitize_text_field( $_POST['gglcptch_public_key'] ) );
				$this->options['private_key']       = stripslashes( sanitize_text_field( $_POST['gglcptch_private_key'] ) );

				$this->options['recaptcha_version'] = in_array( $_POST['gglcptch_recaptcha_version'], array( 'v2', 'invisible', 'v3' ) ) ? $_POST['gglcptch_recaptcha_version'] : $this->options['recaptcha_version'];
				$this->options['theme_v2']          = in_array( $_POST['gglcptch_theme_v2'], array( 'light', 'dark' ) ) ? $_POST['gglcptch_theme_v2'] : $this->options['theme_v2'];

				$this->options['size_v2']  = in_array( $_POST['gglcptch_size_v2'], array( 'normal', 'compact' ) ) ? $_POST['gglcptch_size_v2'] : $this->options['size_v2'];
				$this->options['language'] = array_key_exists( $_POST['gglcptch_language'], $gglcptch_languages ) ? $_POST['gglcptch_language'] : $this->options['language'];

				$this->options['use_multilanguage_locale'] = isset( $_POST['gglcptch_use_multilanguage_locale'] ) ? 1 : 0;
				$this->options['score_v3']                 = isset( $_POST['gglcptch_score_v3'] ) ? (float) $_POST['gglcptch_score_v3'] : 0.5;
				$this->options['all_page_v3']              = isset( $_POST['gglcptch_all_page_v3'] ) ? absint( $_POST['gglcptch_all_page_v3'] ) : 0;
				$this->options['disable_submit']           = isset( $_POST['gglcptch_disable_submit'] ) ? 1 : 0;
				$this->options['hide_badge']               = isset( $_POST['gglcptch_hide_badge'] ) ? 1 : 0;
				$this->options['disable_submit_button']    = isset( $_POST['gglcptch_disable_submit_button'] ) ? 1 : 0;

				$this->options['use_globally'] = intval( $_POST['gglcptch_use_globally'] );

				foreach ( $this->forms as $form_slug => $form_data ) {
					$this->options[ $form_slug ] = isset( $_POST[ "gglcptch_{$form_slug}" ] ) ? 1 : 0;

					if ( 'buddypress_comments' === $form_slug && function_exists( 'bp_get_theme_package_id' ) ) {
						$bp_template_name = bp_get_theme_package_id();

						if ( 'nouveau' === $bp_template_name && 0 === $this->options['disable_submit_button'] && 1 === $this->options['buddypress_comments'] ) {
							$notice = __( 'Please activate the "Disabled Submit Button" option for BuddyPress Comments form to work correctly', 'google-captcha-pro' );
						}
					} elseif ( 'buddypress_comments' === $form_slug && 0 === $this->options['disable_submit_button'] && 1 === $this->options['buddypress_comments'] ) {
						$notice = __( 'Please activate the "Disabled Submit Button" option for BuddyPress Comments form to work correctly (Only for Nouveau theme package)', 'google-captcha-pro' );
					}
				}

				if ( function_exists( 'get_editable_roles' ) ) {
					foreach ( get_editable_roles() as $role => $fields ) {
						$this->options[ $role ] = isset( $_POST[ 'gglcptch_' . $role ] ) ? 1 : 0;
					}
				}

				/*
				 * Update plugin option in the database
				 */
				if ( $this->is_network_options ) {
					if ( 'all' == $_REQUEST['gglcptch_network_apply'] ) {
						$blogids  = $wpdb->get_col( "SELECT `blog_id` FROM $wpdb->blogs" );
						$old_blog = $wpdb->blogid;
						foreach ( $blogids as $blog_id ) {
							switch_to_blog( $blog_id );
							if ( $old_options = get_option( 'gglcptch_options' ) ) {
								$blog_options = array_merge( $old_options, $this->options );
								update_option( 'gglcptch_options', $blog_options );
							} else {
								add_option( 'gglcptch_options', array_merge( $this->default_options, $this->options ) );
							}
						}
						switch_to_blog( $old_blog );
					}
					$this->options['network_apply']  = in_array( $_POST['gglcptch_network_apply'], array( 'all', 'default', 'off' ) ) ? $_POST['gglcptch_network_apply'] : $this->options['network_apply'];
					$this->options['network_view']   = isset( $_REQUEST['gglcptch_network_view'] ) ? 1 : 0;
					$this->options['network_change'] = isset( $_REQUEST['gglcptch_network_change'] ) ? 1 : 0;
					update_site_option( 'gglcptch_options', $this->options );
				} else {
					update_option( 'gglcptch_options', $this->options );
				}

				$message = __( 'Settings saved.', 'google-captcha-pro' );
			}

			return compact( 'message', 'notice', 'error' );
		}

		/**
		 * Displays 'settings' menu-tab
		 *
		 * @access public
		 * @param void
		 * @return void
		 */
		public function tab_settings() {
			global $gglcptch_languages, $wp_version; ?>
			<h3 class="bws_tab_label"><?php _e( 'reCaptcha Settings', 'google-captcha-pro' ); ?></h3>
			<?php $this->help_phrase(); ?>
			<hr>
			<?php if ( $this->forbid_view ) : ?>
				<div class="error inline bws_visible"><p><strong><?php _e( 'Notice:', 'google-captcha-pro' ); ?></strong> <strong><?php _e( 'It is prohibited to view reCaptcha Pro settings on this site in the reCaptcha Pro network settings.', 'google-captcha-pro' ); ?></strong></p></div>
				<?php
			else :
				if ( ! empty( $this->change_permission_attr ) ) {
					?>
					<div class="error inline bws_visible"><p><strong><?php _e( 'Notice:', 'google-captcha-pro' ); ?></strong> <strong><?php _e( 'It is prohibited to change reCaptcha Pro settings on this site in the reCaptcha Pro network settings.', 'google-captcha-pro' ); ?></strong></p></div>
					<?php
				}
				if ( $this->is_network_options ) {
					?>
					<table class="form-table gglcptch_network_settings">
						<tr valign="top">
							<th scope="row"><?php _e( 'Apply Network Settings', 'google-captcha-pro' ); ?></th>
							<td>
								<fieldset>
									<label>
										<input<?php echo $this->change_permission_attr; ?>  type="radio" name="gglcptch_network_apply" value="all" 
										<?php
										if ( 'all' == $this->options['network_apply'] ) {
											echo 'checked="checked"';}
										?>
										/> <?php _e( 'Apply to all sites and use by default', 'google-captcha-pro' ); ?>
										<br />
										<span class="bws_info"><?php _e( 'All current settings on separate sites will be replaced.', 'google-captcha-pro' ); ?></span>
									</label><br />
									<div class="bws_network_apply_all">
										<label><input<?php echo $this->change_permission_attr; ?>  type="checkbox" name="gglcptch_network_change" value="1" 
										<?php
										if ( 1 == $this->options['network_change'] ) {
											echo 'checked="checked"';}
										?>
										/> <?php _e( 'Allow changing the settings on separate websites', 'google-captcha-pro' ); ?></label><br />
										<label><input<?php echo $this->change_permission_attr; ?>  type="checkbox" name="gglcptch_network_view" value="1" 
										<?php
										if ( 1 == $this->options['network_view'] ) {
											echo 'checked="checked"';}
										?>
										/> <?php _e( 'Allow viewing the settings on separate websites', 'google-captcha-pro' ); ?></label><br />
									</div>
									<label>
										<input<?php echo $this->change_permission_attr; ?>  type="radio" name="gglcptch_network_apply" value="default" 
										<?php
										if ( 'default' == $this->options['network_apply'] ) {
											echo 'checked="checked"';}
										?>
										/> <?php _e( 'By default', 'google-captcha-pro' ); ?>
										<br />
										<span class="bws_info"><?php _e( 'Settings will be applied to newly added websites by default.', 'google-captcha-pro' ); ?></span>
									</label><br />
									<label>
										<input<?php echo $this->change_permission_attr; ?>  type="radio" name="gglcptch_network_apply" value="off" 
										<?php
										if ( 'off' == $this->options['network_apply'] ) {
											echo 'checked="checked"';}
										?>
										/> <?php _e( 'Do not apply', 'google-captcha-pro' ); ?>
										<br />
										<span class="bws_info"><?php _e( 'Change the settings on separate sites of the multisite only.', 'google-captcha-pro' ); ?></span>
									</label>
								</fieldset>
							</td>
						</tr>
					</table>
				<?php } ?>
				<div class="bws_tab_sub_label gglcptch_settings_form"><?php _e( 'General', 'google-captcha-pro' ); ?></div>
				

				<table class="form-table gglcptch_settings_form">
					<tr valign="top">
						<th scope="row"><?php _e( 'reCaptcha Version', 'google-captcha-pro' ); ?></th>
						<td>
							<fieldset>
								<?php foreach ( $this->versions as $version => $version_name ) { ?>
									<label>
										<input<?php echo $this->change_permission_attr; ?> type="radio" name="gglcptch_recaptcha_version" value="<?php echo $version; ?>" <?php checked( $version, $this->options['recaptcha_version'] ); ?>> <?php echo $version_name; ?>
									</label>
									<br/>
								<?php } ?>
							</fieldset>
						</td>
					</tr>
				</table>
				<table class="form-table gglcptch_settings_form">
					<div class="bws_info gglcptch_settings_form">
						<?php
						printf(
							__( 'Register your domain name with Google reCaptcha service and add the keys to the fields below. %1$s Get the API Keys. %2$s', 'google-captcha-pro' ),
							'<a target="_blank" href="https://www.google.com/recaptcha/admin#list">',
							'</a>'
						);
						?>
					</div>
					<div class="bws_info gglcptch_settings_form"> 
					<?php
					printf(
						__( 'If you do not want to create API keys use %1$sCaptcha by BestWebSoft%2$s plugin.', 'google-captcha-pro' ),
						'<a target="_blank" href="https://bestwebsoft.com/products/wordpress/plugins/captcha/?k=dcf21edcd5cc9374f5e15c8055e40797">',
						'</a>'
					);
					?>
					</div>
					<div class="bws_info warning gglcptch_settings_form"> 
					<?php
					printf(
						__( 'The Google reCaptcha block loads the webfont "Roboto" from fonts.googleapis.com. If you do not want to load this font use %1$sCaptcha by BestWebSoft%2$s plugin.', 'google-captcha-pro' ),
						'<a target="_blank" href="https://bestwebsoft.com/products/wordpress/plugins/captcha/?k=dcf21edcd5cc9374f5e15c8055e40797">',
						'</a>'
					);
					?>
					</div>
					<?php foreach ( $this->keys as $key => $fields ) { ?>
						<tr>
							<th><?php echo $fields['display_name']; ?></th>
							<td>
								<input<?php echo $this->change_permission_attr; ?> class="regular-text" type="text" name="<?php echo $fields['form_name']; ?>" value="<?php echo $this->options[ $key . '_key' ]; ?>" maxlength="200" />
								<label class="gglcptch_error_msg error"><?php echo $fields['error_msg']; ?></label>
								<span class="dashicons dashicons-yes gglcptch_verified 
								<?php
								if ( ! isset( $this->options['keys_verified'] ) || true !== $this->options['keys_verified'] ) {
									echo 'hidden';}
								?>
								"></span>
							</td>
						</tr>
						<?php
					}
					if ( ! empty( $this->options['public_key'] ) && ! empty( $this->options['private_key'] ) ) {
						?>
						<tr class="hide-if-no-js">
							<th></th>
							<td>
								<div id="gglcptch-test-keys">
									<a <?php echo $this->change_permission_attr; ?> class="button button-secondary" href="<?php
										echo add_query_arg(
											array(
												'_wpnonce'   => wp_create_nonce( 'gglcptch-test-keys' ),
												'action'     => 'gglcptch-test-keys',
												'is_network' => $this->is_network_options ? '1' : '0',
											),
											admin_url( 'admin-ajax.php' )
										);
										?>"><?php _e( 'Test reCaptcha', 'google-captcha-pro' ); ?></a>
								</div>
							</td>
						</tr>
					<?php } ?>
					<tr valign="top">
						<th scope="row"><?php _e( 'Enable reCaptcha for', 'google-captcha-pro' ); ?></th>
						<td>
							<!--[if !IE]> -->
							<div class="gglcptch-settings-accordion">
							<!-- <![endif]-->
								<?php
								foreach ( $this->sections as $section_slug => $section ) {
									if ( empty( $section['name'] ) || empty( $section['forms'] ) || ! is_array( $section['forms'] ) ) {
										continue;
									}

									$section_notice = ! empty( $section['section_notice'] ) ? $section['section_notice'] : '';
									?>
									<p class="gglcptch_section_header">
										<i><?php echo $section['name']; ?></i>
										<?php if ( ! empty( $section_notice ) ) { ?>
											&nbsp;<span class="bws_info"><?php echo $section_notice; ?></span>
										<?php } ?>
									</p>
									<fieldset class="gglcptch_section_forms">
										<?php
										foreach ( $section['forms'] as $form_slug ) {
											$form_notice = $this->forms[ $form_slug ]['form_notice'];
											/* Plugin 'Fast Secure Contact Form' has been closed for new installations */
											if ( 'si_contact_form' === $form_slug && strstr( $form_notice, 'Install Now' ) ) {
												$form_notice = __( 'This plugin has been closed for new installations.', 'google-captcha-pro' );
											}
											$form_atts = '';
											if ( '' == $this->change_permission_attr && ( '' != $form_notice || '' != $section_notice ) ) {
												$form_atts .= disabled( 1, 1, false );
											}
											$form_atts .= checked( ! empty( $this->options[ $form_slug ] ), true, false );
											?>
											<label>
												<input type="checkbox"
												<?php
												echo $this->change_permission_attr;
												echo $form_atts;
												?>
												name="gglcptch_<?php echo $form_slug; ?>" value="1" /> <?php echo $this->forms[ $form_slug ]['form_name']; ?>
											</label>
											<?php if ( '' != $form_notice ) { ?>
												&nbsp;<span class="bws_info"><?php echo $form_notice; ?></span>
											<?php } ?>
											<br />
										<?php } ?>
										<hr />
									</fieldset>
								<?php } ?>
							<!--[if !IE]> -->
							</div> <!-- .gglcptch-settings-accordion -->
							<!-- <![endif]-->
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">
							<?php _e( 'reCaptcha Domain', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<select <?php echo $this->change_permission_attr; ?> name="gglcptch_use_globally">
								<option value="0" <?php selected( $this->options['use_globally'], 0 ); ?>>google.com</option>
								<option value="1" <?php selected( $this->options['use_globally'], 1 ); ?>>recaptcha.net</option>
							</select>
							<div class="bws_info">
							<?php _e( 'If Google is not accessible or blocked in your country select other one.', 'google-captcha-pro' ); ?>
							</div>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Language', 'google-captcha-pro' ); ?></th>
						<td>
							<select<?php echo $this->change_permission_attr; ?> id="gglcptch_language" name="gglcptch_language">
								<?php foreach ( $gglcptch_languages as $code => $name ) { ?>
									<option value="<?php echo $code; ?>" <?php selected( $this->options['language'], $code ); ?>><?php echo $name; ?></option>
								<?php } ?>
							</select>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">Multilanguage</th>
						<td>
							<?php
							$plugin_info = gglcptch_plugin_status( array( 'multilanguage/multilanguage.php', 'multilanguage-pro/multilanguage-pro.php' ), $this->all_plugins, $this->is_network_options );
							$attrs       = $plugin_notice = '';
							if ( 'deactivated' == $plugin_info['status'] ) {
								$attrs         = 'disabled="disabled"';
								$plugin_notice = ' <a href="' . self_admin_url( 'plugins.php' ) . '">' . __( 'Activate', 'google-captcha-pro' ) . '</a>';
							} elseif ( 'not_installed' == $plugin_info['status'] ) {
								$attrs         = 'disabled="disabled"';
								$plugin_notice = ' <a href="https://bestwebsoft.com/products/wordpress/plugins/multilanguage/?k=390f8e0d92066f2b73a14429d02dcee7&pn=109&v=' . $this->plugins_info['Version'] . '&wp_v=' . $wp_version . '" target="_blank">' . __( 'Install Now', 'google-captcha-pro' ) . '</a>';
							}
							?>
							<label>
								<input<?php echo $this->change_permission_attr; ?> id="gglcptch_use_multilanguage_locale" type="checkbox" <?php echo $attrs; ?> <?php checked( $this->options['use_multilanguage_locale'], 1 ); ?> name="gglcptch_use_multilanguage_locale" value="1" /> <span class="bws_info">
								 <?php
									_e( 'Enable to switch language automatically on multilingual website using the Multilanguage plugin.', 'google-captcha-pro' );
									echo $plugin_notice;
									?></span>
							</label>
						</td>
					</tr>
				</table>
				<div class="bws_tab_sub_label gglcptch_settings_form"><?php _e( 'Appearance', 'google-captcha-pro' ); ?></div>
				<table class="form-table gglcptch_settings_form">
					<tr class="gglcptch_theme_v2" valign="top">
						<th scope="row">
							<?php _e( 'Theme', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<select<?php echo $this->change_permission_attr; ?> name="gglcptch_theme_v2">
								<option value="light" <?php selected( 'light', $this->options['theme_v2'] ); ?>><?php _e( 'Light', 'google-captcha-pro' ); ?></option>
								<option value="dark" <?php selected( 'dark', $this->options['theme_v2'] ); ?>><?php _e( 'Dark', 'google-captcha-pro' ); ?></option>
							</select>
						</td>
					</tr>
					<tr class="gglcptch_theme_v2" valign="top">
						<th scope="row">
							<?php _e( 'Size', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<fieldset>
								<label><input<?php echo $this->change_permission_attr; ?> name="gglcptch_size_v2" type="radio" value="normal" <?php checked( 'normal', $this->options['size_v2'] ); ?>><?php _e( 'Normal', 'google-captcha-pro' ); ?></label>
								<br />
								<label><input<?php echo $this->change_permission_attr; ?> name="gglcptch_size_v2" type="radio" value="compact" <?php checked( 'compact', $this->options['size_v2'] ); ?>><?php _e( 'Compact', 'google-captcha-pro' ); ?></label>
							</fieldset>
						</td>
					</tr>
					<tr class="gglcptch_badge_v3" valign="top">
						<th scope="row">
							<?php _e( 'Hide reCaptcha Badge', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<input<?php echo $this->change_permission_attr; ?> id="gglcptch_hide_badge" type="checkbox" <?php checked( ! empty( $this->options['hide_badge'] ) ); ?> name="gglcptch_hide_badge" value="1" />
							<span class="bws_info">
								<?php _e( 'Enable to hide reCaptcha Badge for Version 3 and Invisble reCaptcha.', 'google-captcha-pro' ); ?>
							</span>
						</td>
					</tr>
				</table>
				<div class="bws_tab_sub_label gglcptch_settings_form"><?php _e( 'Additional Protective Measures', 'google-captcha-pro' ); ?></div>
				<table class="form-table gglcptch_settings_form">
					<tr class="gglcptch_score_v3" valign="top">
						<th scope="row">
							<?php _e( 'Score', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<input name="gglcptch_score_v3" id="gglcptch_score_v3" type="range" list="gglcptch_score_v3_rangeList" min="0" max="1.0" step="0.1" value="<?php echo $this->options['score_v3']; ?>">
							<output id="gglcptch_score_out_v3" for="gglcptch_score_v3"></output>
							<span class="bws_info" style="display: block;"><?php printf( __( 'Set the minimum verification score from %1$s to %2$s (default is %3$s).', 'google-captcha-pro' ), 0, 1, 0.5 ); ?></span>
						</td>
					</tr>
					<tr class="gglcptch_score_v3" valign="top">
						<th scope="row">
							<?php _e( 'Display for', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<label><input name="gglcptch_all_page_v3" type="radio" value="0" <?php checked( 0 === $this->options['all_page_v3'], true ); ?> /><?php _e( 'Only form', 'google-captcha-pro' ); ?></label>
							<br />
							<label><input name="gglcptch_all_page_v3" type="radio" value="1" <?php checked( 1 === $this->options['all_page_v3'], true ); ?> /><?php _e( 'All pages', 'google-captcha-pro' ); ?></label>
						</td>
					</tr>    
					<tr valign="top">
						<th scope="row"><?php _e( 'Hide reCaptcha for', 'google-captcha-pro' ); ?></th>
						<td>
							<fieldset>
								<?php
								if ( function_exists( 'get_editable_roles' ) ) {
									foreach ( get_editable_roles() as $role => $fields ) {
										printf(
											'<label><input %1$s type="checkbox" name="%2$s" value="%3$s" %4$s> %5$s</label><br/>',
											$this->change_permission_attr,
											'gglcptch_' . $role,
											$role,
											checked( ! empty( $this->options[ $role ] ), true, false ),
											translate_user_role( $fields['name'] )
										);
									}
								}
								?>
							</fieldset>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Allow List Notification', 'google-captcha-pro' ); ?></th>
						<td>
							<textarea<?php echo $this->change_permission_attr; ?> name="gglcptch_allowlist_message"><?php echo $this->options['allowlist_message']; ?></textarea>
							<div class="bws_info"><?php _e( 'This message will be displayed instead of the reCaptcha.', 'google-captcha-pro' ); ?></div>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Advanced Protection', 'google-captcha-pro' ); ?></th>
						<td>
							<input<?php echo $this->change_permission_attr; ?> id="gglcptch_disable_submit" type="checkbox" <?php checked( ! empty( $this->options['disable_submit'] ) ); ?> name="gglcptch_disable_submit" value="1" />
							<span class="bws_info">
								<?php _e( 'Enable to keep submit button disabled until reCaptcha is loaded (do not use this option if you see "Failed to load Google reCaptcha" message).', 'google-captcha-pro' ); ?>
							</span>
						</td>
					</tr>
					<tr class="gglcptch_submit_v2" valign="top">
						<th scope="row">
							<?php _e( 'Disabled Submit Button', 'google-captcha-pro' ); ?>
						</th>
						<td>
							<input<?php echo $this->change_permission_attr; ?> id="gglcptch_disable_submit_button" type="checkbox" <?php checked( $this->options['disable_submit_button'] ); ?> name="gglcptch_disable_submit_button" value="1" />
							<span class="bws_info">
							<?php _e( 'Enable to keep submit button disabled until user passes the reCaptcha test (for Version 2).', 'google-captcha-pro' ); ?>
						</span>
						</td>
					</tr>
				</table>
				<?php
			endif;
		}

		/**
		 * Display custom error\message\notice
		 *
		 * @access public
		 * @return void
		 */
		public function display_custom_messages() {
			if ( ! empty( $this->options['need_keys_verified_check'] ) ) {
				?>
				<div class="updated inline bws-notice"><p><strong><?php _e( 'reCaptcha version was changed. Please submit "Test reCaptcha" and regenerate Site and Secret keys if necessary.', 'google-captcha-pro' ); ?></strong></p></div>
				<?php
			}
		}

		public function information_postbox_bottom() {
			?>
			<div class="misc-pub-section">
			<?php
			printf(
				__( 'ReCaptcha plugin is fully compliant with GDPR. %1$s Learn more %2$s', 'google-captcha-pro' ),
				'<a target="_blank" href="https://support.bestwebsoft.com/hc/en-us/articles/4406398670097">',
				'</a>'
			);
			?>
			</div>
			<?php
		}

		/**
		 * Display custom metabox
		 *
		 * @access public
		 * @param  void
		 * @return array    The action results
		 */
		public function display_metabox() {
			?>
			<div class="postbox">
				<h3 class="hndle">
					<?php _e( 'reCaptcha Shortcode', 'google-captcha-pro' ); ?>
				</h3>
				<div class="inside">
					<?php _e( 'Add reCaptcha to your posts or pages using the following shortcode:', 'google-captcha-pro' ); ?>
					<?php bws_shortcode_output( '[bws_google_captcha]' ); ?>
				</div>
			</div>
			<?php
		}
	}
}
