<?php
/**
 * BWS Recaptcha for Calbera Forms
 *
 * @since 1.64
 */

if ( ! function_exists( 'gglcptch_field_types' ) ) {
	function gglcptch_field_types ( $field_types ) {
		$field_types['gglcptch'] = array(
			"field"       => __( 'BWS reCaptcha', 'google-captcha-pro' ),
			"file"        => dirname( __FILE__ ) . '/gglcptch-caldera/field.php',
			"category"    => 'BWS',
			"description" => __( 'Add BWS reCaptcha to your form', 'google-captcha-pro' ),
			"setup"       => array(
				"preview"  => dirname( __FILE__ ) . '/gglcptch-caldera/preview.php'
			)
		);
		return $field_types;
	}
}
if ( ! function_exists( 'gglcptch_validate_field' ) ) {
	function gglcptch_validate_field () {
		$gglcptch_check = gglcptch_check( 'caldera_forms' );
			if ( is_wp_error( $gglcptch_check['errors'] ) )
				return $gglcptch_check['errors'];
			else 
				return 1;
	}
}


if ( ! function_exists( 'gglcptch_recaptcha_required' ) ) {
	function gglcptch_recaptcha_required( $field ) {
		$field['required'] = 1;
		return $field;
	}
}

$is_user_logged_in = is_user_logged_in();
if ( gglcptch_is_recaptcha_required( 'caldera_forms', $is_user_logged_in ) ) {
	add_filter( 'caldera_forms_get_field_types', 'gglcptch_field_types' );
	add_filter( 'caldera_forms_validate_field_gglcptch', 'gglcptch_validate_field' );
	add_filter( 'caldera_forms_render_get_field_type-gglcptch', 'gglcptch_recaptcha_required' );
}